using System;
using System.Xml;
using Server;
using Server.Items;
using Server.Mobiles;
using Server.Gumps;
using Server.Spells;
using Server.Spells.First;
using Server.Spells.Second;
using Server.Spells.Third;
using Server.Spells.Fourth;
using Server.Spells.Fifth;
using Server.Spells.Sixth;
using Server.Spells.Seventh;
using Server.Spells.Eighth;
using Server.Spells.Chivalry;
using System.Collections;
using System.Collections.Generic;


namespace Server.Regions
{
	public class IceRegion : WispRegion
	{
 		public static int RandomIceHue { get { return Utility.RandomList( 1049, 1050, 1051, 1052, 1053 ); } }
      
      public IceRegion( XmlElement xml, Map map, Region parent ) : base( xml, map, parent )
		{
		}
      
		public override void OnEnter( Mobile m )
		{
			base.OnEnter( m );
		
			if ( m.Player && m.Alive && m.AccessLevel == AccessLevel.Player )
			{
				m.PlaySound( 22 );
            m.SendMessage( "Mrazivý vzduch ti pronika az do morku kosti!" );
			}
		}
      
		public override bool OnDoubleClick(Mobile m, object o)
		{
			if ( m.AccessLevel > AccessLevel.Player )
				return base.OnDoubleClick(m, o);
			
			if ( /*o is GreaterHealPotion || */o is SuperPotion || o is TotalManaRefreshPotion || o is BankCrystal || o is EnhancedBandage )
			{
				m.SendMessage( "Tento predmet zde nemuzes pouzit." );
				return false;
			}
			else if ( o is Xanthos.Interfaces.IShrinkItem )
			{
				BaseCreature bc = (BaseCreature) ((Xanthos.Interfaces.IShrinkItem)o).ShrunkenPet;
				
				if ( bc != null && bc.IsBonded )
				{
					if ( bc is GiantIceWorm )
                  return true;
               
               m.SendMessage( "Zde nemuzes odshrinknout bondle pety." );
					return false;
				}
			}

			return true;
		}
		
		public override bool OnDamage( Mobile from, ref int Damage )
		{
			if ( from is BaseCreature )
			{
				BaseCreature bc = (BaseCreature) from;
				
				if ( bc.IsBonded && !( bc is GiantIceWorm ) )
				{
					from.Kill();
					return false;
				}
				else if ( bc.Controlled && !bc.Summoned ) //10% dmg pro ovladane nesummony
					Damage = (int) ( Damage * 0.5 );
			}
			
			return true;
		}
      
		public override bool OnDeath( Mobile m )
		{
			if ( m is BaseCreature )
			{
				BaseCreature bc = (BaseCreature) m;
            
            if ( bc is BaseChampion || ( bc.IsTeragon && bc.Fame > 10000 && Utility.RandomDouble() < 0.1 ) )
            {
                Item klic = new Klic();
                klic.Name = "krvavy snih";
                klic.LootType = LootType.Cursed;
                klic.Stackable = false;
                klic.ItemID = 0x3185;
                klic.Hue = 33;
                bc.PackItem( klic );
            }
			}
			
			return base.OnDeath( m );
		}
	}
}
